/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRequestForward;
import filenet.ws.listener.utils.Constants;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSLogger;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;

public class WSMsgForwardHandler
extends BasicHandler {
    private WSLogger m_wsLogger = null;
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected static final String m_className = "WSMsgForwardHandler";
    protected static final long timeout = 10000L;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Dec 2008 10:19:56  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        block26: {
            String m_method = "invoke";
            logger.entering(m_className, "invoke");
            try {
                Boolean forwarded;
                String targetHost;
                int targetPort;
                block25: {
                    WSRequestForward reqForward;
                    block24: {
                        reqForward = new WSRequestForward();
                        targetPort = Constants.LISTENER_PROPERTY_WSRM_CLIENT_LISTENER_PORT_DEFAULT;
                        targetHost = null;
                        WSListenerProperties props = null;
                        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                        if (req != null) {
                            props = (WSListenerProperties)req.getAttribute("P8BPM.wsListenerProperties");
                        }
                        this.m_wsLogger = (WSLogger)msgContext.getProperty("MC.P8BPM.WSLOGGER");
                        if (props != null) {
                            if (logger.isFinest()) {
                                logger.finest(m_className, "invoke", "Retrieving targt host and port");
                            }
                            try {
                                targetHost = props.getProperty("filenet.wsrm.client.listener.host");
                                if (WSConstants.isLoopbackAddress(targetHost)) {
                                    try {
                                        targetHost = InetAddress.getLocalHost().getHostName();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (logger.isFinest()) {
                                    logger.finest(m_className, "invoke", "TargetHost = " + targetHost);
                                }
                                targetPort = Integer.parseInt(props.getProperty("filenet.wsrm.client.listener.port"));
                                if (logger.isFinest()) {
                                    logger.finest(m_className, "invoke", "TargetPort = " + targetPort);
                                }
                            }
                            catch (Throwable t) {
                                if (!logger.isFinest()) break block24;
                                logger.finest(m_className, "invoke", "Failed retrieving targt host and port");
                            }
                        }
                    }
                    try {
                        MessageContext t = msgContext;
                        synchronized (t) {
                            reqForward.addRequest(msgContext, targetPort, targetHost);
                            msgContext.wait(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        if (!logger.isFinest()) break block25;
                        logger.finest(m_className, "invoke", "Freed by timeout");
                    }
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Free finally");
                }
                if ((forwarded = (Boolean)msgContext.getProperty("MC.P8BPM.RM.FORWARDED")) != null && forwarded.booleanValue()) {
                    String s = "Message forwarded to " + (targetHost == null ? "localhost" : targetHost) + ":" + targetPort;
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", s);
                    }
                    if (this.m_wsLogger != null) {
                        this.m_wsLogger.append(s).eoln();
                    }
                    break block26;
                }
                String desc = "Timed out!";
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Timed out!");
                }
                QName fault = WSConstants.getDefaultWSConstants().FAULT_FORWARD_TIMED_OUT;
                AxisFault retFault = new AxisFault(fault, desc, null, null);
                retFault.addFaultDetail(fault, desc);
                logger.throwing(m_className, "invoke", retFault);
                throw retFault;
            }
            finally {
                logger.exiting(m_className, "invoke");
                if (this.m_wsLogger != null) {
                    this.m_wsLogger.println("WSForwardProcess Exits");
                }
            }
        }
    }
}

